<?php
/**
 * GDF Core
 *
 * Handles setting up the GDF theme.
 *
 * @author   AyeCode
 * @category API
 * @package  GDF/Core
 * @since    2.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GDF_Theme {

	/**
	 * GDF version.
	 *
	 * @var string
	 */
	public $version = GDF_VERSION;

	/**
	 * Setup class.
	 *
	 * @since 2.0.0
	 */
	public function __construct() {

		// actions
		add_action( 'after_setup_theme', array(__CLASS__,'head_clean') );
		add_action( 'after_setup_theme', array(__CLASS__,'register_menus') );
		add_action( 'after_setup_theme', array(__CLASS__,'theme_support') );
		add_action( 'widgets_init', array(__CLASS__,'register_sidebars') );
		add_action( 'widgets_init', array(__CLASS__,'register_widgets') );
		add_action('wp_head',array(__CLASS__,'extra_css'),1001);
		add_action('wp_head',array(__CLASS__,'extra_js'),1002);
	}

	public static function register_widgets(){
		register_widget( 'GDF_Widget_Welcome_Login' );
	}

	/**
	 * Output user defined JS
	 */
	public static function extra_js(){
		global $gdf;
		if(!empty($gdf) && $gdf['override-js']){echo "<script type=\"text/javascript\">".$gdf['override-js']."</script>";}
	}

	/**
	 * Output user defined CSS
	 */
	public static function extra_css(){
		global $gdf;
		if(!empty($gdf) && $gdf['override-css']){echo "<style type=\"text/css\" >".$gdf['override-css']."</style>";}
	}

	/**
	 * Register the theme sidebars
	 */
	public static function register_sidebars(){
		global $gdf;

		$before_widget = apply_filters( 'geodir_before_widget','<section id="%1$s" class="widget geodir-widget %2$s">' );
		$after_widget = apply_filters( 'geodir_after_widget','</section>' );
		$before_title = apply_filters( 'geodir_before_title','<h3 class="widget-title">' );
		$after_title = apply_filters( 'geodir_after_title','</h3>' );


		register_sidebar(array(
			'id' => 'blog-details',
			'name' => __( 'Blog Sidebar', "geodirectory_framework" ),
			'description' => __( 'For single blog posts.', "geodirectory_framework" ),
			'before_widget' => $before_widget,
			'after_widget' => $after_widget,
			'before_title' => $before_title ,
			'after_title' => $after_title,
		));

		register_sidebar(array(
			'id' => 'blog-listing',
			'name' => __( 'Blog Archive Sidebar', "geodirectory_framework" ),
			'description' => __( 'For blog archive/category pages.', "geodirectory_framework" ),
			'before_widget' => $before_widget,
			'after_widget' => $after_widget,
			'before_title' => $before_title ,
			'after_title' => $after_title,
		));

		register_sidebar(array(
			'id' => 'page',
			'name' => __( 'Page Sidebar', "geodirectory_framework" ),
			'description' => __( 'Sidebar for all pages.', "geodirectory_framework" ),
			'before_widget' => $before_widget,
			'after_widget' => $after_widget,
			'before_title' => $before_title ,
			'after_title' => $after_title,
		));

		if(!empty($gdf) && $gdf['footer-widgets']>0){
			register_sidebar(array(
				'id' => 'footer-1',
				'name' => __( 'Footer 1', "geodirectory_framework" ),
				'description' => __( 'The first footer', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));
		}

		if(!empty($gdf) && $gdf['footer-widgets']>1){
			register_sidebar(array(
				'id' => 'footer-2',
				'name' => __( 'Footer 2', "geodirectory_framework" ),
				'description' => __( 'The second footer', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));
		}

		if(!empty($gdf) && $gdf['footer-widgets']>2){
			register_sidebar(array(
				'id' => 'footer-3',
				'name' => __( 'Footer 3', "geodirectory_framework" ),
				'description' => __( 'The third footer', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));
		}

		if(!empty($gdf) && $gdf['footer-widgets']>3){
			register_sidebar(array(
				'id' => 'footer-4',
				'name' => __( 'Footer 4', "geodirectory_framework" ),
				'description' => __( 'The forth footer', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));
		}

		register_sidebar(array(
			'id' => 'header-right',
			'name' => __( 'Header Right', "geodirectory_framework" ),
			'description' => __( 'Right side of header', "geodirectory_framework" ),
			'before_widget' => $before_widget,
			'after_widget' => $after_widget,
			'before_title' => $before_title ,
			'after_title' => $after_title,
		));

		if(!empty($gdf) && !$gdf['head-gdf-adminbar']) {
			register_sidebar( array(
				'id'            => 'admin-bar-left',
				'name'          => __( 'Admin Bar Left', "geodirectory_framework" ),
				'description'   => __( 'Left side of admin bar', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget'  => $after_widget,
				'before_title'  => $before_title,
				'after_title'   => $after_title,
			) );

			register_sidebar( array(
				'id'            => 'admin-bar-right',
				'name'          => __( 'Admin Bar Right', "geodirectory_framework" ),
				'description'   => __( 'Right side of admin bar', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget'  => $after_widget,
				'before_title'  => $before_title,
				'after_title'   => $after_title,
			) );
		}

		// GD sidebars
		if(defined('GEODIRECTORY_VERSION')){

			register_sidebar(array(
				'name' => __('GD Top', 'geodirectory_framework'),
				'id' => 'sidebar-gd-top',
				'description' => __( 'Full width top widget area.', 'geodirectory_framework' ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));

			register_sidebar(array(
				'id' => 'page-details',
				'name' => __( 'GD Page Details', "geodirectory_framework" ),
				'description' => __( 'The first (primary) sidebar.', "geodirectory_framework" ),
				'before_widget' => $before_widget,
				'after_widget' => $after_widget,
				'before_title' => $before_title ,
				'after_title' => $after_title,
			));
		}

	}

	/**
	 * Tidy the head up.
	 */
	public static function head_clean(){

		// EditURI link
		remove_action( 'wp_head', 'rsd_link' );
		// windows live writer
		remove_action( 'wp_head', 'wlwmanifest_link' );
		// index link
		remove_action( 'wp_head', 'index_rel_link' );
		// previous link
		remove_action( 'wp_head', 'parent_post_rel_link', 10);
		// start link
		remove_action( 'wp_head', 'start_post_rel_link', 10);
		// links for adjacent posts
		remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10);
		// WP version
		remove_action( 'wp_head', 'wp_generator' );

		// remove admin bar if set to do so
		global $gdf;
		if(!empty($gdf) && $gdf['head-wp-adminbar']){add_filter( 'show_admin_bar', '__return_false' );}
	}

	/**
	 * Register menus
	 */
	public static function register_menus(){

		register_nav_menus(
			array(
				'main-nav' => __( 'The Main Menu', "geodirectory_framework" ),   // main nav in header
				'footer-links' => __( 'Footer Links', "geodirectory_framework" ) // secondary nav in footer
			)
		);

	}

	/**
	 * Add theme supports
	 */
	public static function theme_support(){
		
		// Translations
		load_theme_textdomain( 'geodirectory_framework', get_stylesheet_directory() . '/languages' );

		// wp thumbnails (sizes handled in functions.php)
		add_theme_support( 'post-thumbnails' );

		// default thumb size
		set_post_thumbnail_size( 125, 125, true );

		// rss thingy
		add_theme_support( 'automatic-feed-links' );

		// adding post format support
		add_theme_support( 'post-formats',
			array(
				'aside',             // title less blurb
				'gallery',           // gallery of images
				'link',              // quick link to other site
				'image',             // an image
				'quote',             // a quick quote
				'status',            // a Facebook like status update
				'video',             // video
				'audio',             // audio
				'chat'               // chat transcript
			)
		);

		// Enables plugins and themes to manage the document title.
		add_theme_support( 'title-tag' );

	}

	
	

}
new GDF_Theme();